# Generated by Django 5.2.7 on 2025-12-17 07:41

import django.db.models.deletion
import django.utils.timezone
import esign.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Signature',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254)),
                ('image', models.ImageField(upload_to=esign.models.sig_image_path)),
                ('initials_image', models.ImageField(blank=True, null=True, upload_to=esign.models.sig_image_path)),
                ('name', models.CharField(blank=True, max_length=150)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254, unique=True)),
                ('phone', models.CharField(max_length=20, unique=True)),
                ('is_email_verified', models.BooleanField(default=False)),
                ('is_phone_verified', models.BooleanField(default=False)),
                ('temp_email_code', models.CharField(blank=True, max_length=6, null=True)),
                ('temp_phone_code', models.CharField(blank=True, max_length=6, null=True)),
                ('signature_font', models.CharField(blank=True, max_length=255, null=True)),
                ('is_active', models.BooleanField(default=True)),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now)),
            ],
        ),
        migrations.CreateModel(
            name='ContactInquiry',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('email', models.EmailField(max_length=254)),
                ('phone', models.CharField(max_length=50)),
                ('company_name', models.CharField(max_length=255)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Document',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=250)),
                ('subject', models.CharField(max_length=250)),
                ('message', models.TextField()),
                ('reminder_frequency', models.PositiveIntegerField(blank=True, null=True)),
                ('file', models.FileField(upload_to=esign.models.upload_doc_path)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('signed', 'Signed'), ('approved', 'Approved'), ('cancelled', 'Cancelled')], default='pending', max_length=20)),
                ('merged_file', models.FileField(blank=True, null=True, upload_to='merged/')),
                ('is_template', models.BooleanField(default=False)),
                ('sign_order_enabled', models.BooleanField(default=False)),
                ('category', models.CharField(choices=[('employment', 'Employment / HR'), ('legal', 'Legal / Compliance'), ('finance', 'Finance / Accounting'), ('sales', 'Sales / Marketing'), ('procurement', 'Procurement / Operations'), ('government', 'Government / Administrative'), ('education', 'Education / Training'), ('healthcare', 'Healthcare / Medical'), ('it', 'IT / Software'), ('misc', 'Miscellaneous / Personal')], default='misc', max_length=50)),
                ('template_id', models.CharField(blank=True, max_length=150, null=True)),
                ('is_editable', models.BooleanField(default=False)),
                ('is_canceled', models.BooleanField(default=False)),
                ('is_draft', models.BooleanField(default=False)),
                ('valid_until', models.DateTimeField(blank=True, help_text='Document is valid until this date', null=True)),
                ('favorite_by', models.ManyToManyField(blank=True, related_name='favorite_templates', to=settings.AUTH_USER_MODEL)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='documents', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='DocumentSignFlow',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(max_length=64, unique=True)),
                ('recipient_name', models.CharField(blank=True, max_length=255, null=True)),
                ('recipient_email', models.EmailField(blank=True, max_length=254, null=True)),
                ('order', models.PositiveIntegerField()),
                ('is_signed', models.BooleanField(default=False)),
                ('role', models.CharField(choices=[('signer', 'Signer'), ('viewer', 'Viewer'), ('cc', 'CC')], default='signer', max_length=20)),
                ('is_viewed', models.BooleanField(default=False)),
                ('viewed_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('signed_at', models.DateTimeField(blank=True, null=True)),
                ('merged_file', models.FileField(blank=True, null=True, upload_to='signed_docs/')),
                ('is_canceled', models.BooleanField(default=False)),
                ('assigned_at', models.DateTimeField(blank=True, null=True)),
                ('assigned_by', models.CharField(blank=True, max_length=255, null=True)),
                ('reminder_days', models.PositiveIntegerField(blank=True, null=True)),
                ('last_reminder_sent', models.DateTimeField(blank=True, null=True)),
                ('next_reminder_sent', models.DateTimeField(blank=True, null=True)),
                ('security_token', models.CharField(blank=True, max_length=255, null=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='sign_flow', to='esign.document')),
            ],
            options={
                'ordering': ['order'],
            },
        ),
        migrations.CreateModel(
            name='MarketingSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source', models.CharField(max_length=100)),
                ('status', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Profile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('phone', models.CharField(blank=True, max_length=15, null=True)),
                ('email_otp', models.CharField(blank=True, max_length=6, null=True)),
                ('mobile_otp', models.CharField(blank=True, max_length=6, null=True)),
                ('is_verified', models.BooleanField(default=False)),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SignatureBox',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page', models.IntegerField()),
                ('x', models.FloatField()),
                ('y', models.FloatField()),
                ('width', models.FloatField()),
                ('height', models.FloatField()),
                ('type', models.CharField(max_length=20)),
                ('rotation', models.FloatField(default=0)),
                ('color', models.CharField(default='#000000', max_length=20)),
                ('font_family', models.CharField(default='Arial', max_length=100)),
                ('font_size', models.IntegerField(default=10)),
                ('font_weight', models.CharField(default='normal', max_length=20)),
                ('font_style', models.CharField(default='normal', max_length=20)),
                ('text_decoration', models.CharField(default='none', max_length=20)),
                ('assigned_email', models.EmailField(blank=True, max_length=254, null=True)),
                ('required', models.BooleanField(default=False)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='esign.document')),
            ],
        ),
        migrations.CreateModel(
            name='SignaturePage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page', models.CharField(max_length=20)),
                ('allowed', models.BooleanField(default=True)),
                ('token', models.CharField(blank=True, db_index=True, max_length=64, null=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='esign.document')),
                ('user_id', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='signaturespage', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='SignaturePlacement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('page_number', models.PositiveIntegerField()),
                ('x', models.FloatField()),
                ('y', models.FloatField()),
                ('width', models.FloatField()),
                ('height', models.FloatField()),
                ('placed_at', models.DateTimeField(auto_now_add=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='placements', to='esign.document')),
                ('signature', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='esign.signature')),
            ],
        ),
        migrations.CreateModel(
            name='SigningToken',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(max_length=128, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('expires_at', models.DateTimeField()),
                ('used', models.BooleanField(default=False)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='esign.document')),
            ],
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('plan', models.CharField(choices=[('monthly', 'Monthly'), ('yearly', 'Yearly'), ('free_trial', 'Free Trial')], max_length=20)),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('active', 'Active'), ('failed', 'Failed'), ('canceled', 'Canceled')], default='pending', max_length=20)),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('stripe_checkout_session_id', models.CharField(blank=True, max_length=255, null=True)),
                ('stripe_payment_intent_id', models.CharField(blank=True, max_length=255, null=True)),
                ('stripe_payment_status', models.CharField(blank=True, max_length=50, null=True)),
                ('razorpay_payment_id', models.CharField(blank=True, max_length=255, null=True)),
                ('razorpay_order_id', models.CharField(blank=True, max_length=255, null=True)),
                ('razorpay_signature', models.CharField(blank=True, max_length=255, null=True)),
                ('amount_cents', models.PositiveIntegerField(blank=True, null=True)),
                ('currency', models.CharField(default='usd', max_length=10)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
    ]
